var __extends = this.__extends || function (d, b) {
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var VisualProfiler;
(function (VisualProfiler) {
    var CpuUsageModel = (function () {
        function CpuUsageModel(session) {
            this._session = session;
        }
        CpuUsageModel.prototype.getCpuUsage = function (duration, granularity) {
            return this._session.queryCPUUsage(duration.begin.nsec, duration.end.nsec, granularity);
        };
        return CpuUsageModel;
    })();
    VisualProfiler.CpuUsageModel = CpuUsageModel;    
    var CpuUsageViewModel = (function () {
        function CpuUsageViewModel(model, globalRuler) {
            this.barGap = 1;
            this.barWidth = 4;
            this.rightPadding = 40;
            this.yAxisWidth = 34;
            this._model = model;
            this._globalRuler = globalRuler;
            this._globalRuler.addEventListener(VisualProfiler.GlobalRuler.ActiveRangeChangedEventType, this.onActiveRangeChanged.bind(this));
            this._globalRuler.addEventListener(VisualProfiler.GlobalRuler.SelectionChangedEventType, this.onSelectionChanged.bind(this));
        }
        Object.defineProperty(CpuUsageViewModel.prototype, "activeRange", {
            get: function () {
                return this._globalRuler.activeRange;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CpuUsageViewModel.prototype, "bucketWidth", {
            get: function () {
                return this.barGap + this.barWidth;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CpuUsageViewModel.prototype, "selection", {
            get: function () {
                return this._selection;
            },
            set: function (selection) {
                this._selection = selection;
                this._globalRuler.setSelection(selection, false);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CpuUsageViewModel.prototype, "granularity", {
            get: function () {
                var graphDuration = this.activeRange.elapsed.nsec;
                if(graphDuration <= 0 || this.viewWidth <= 0) {
                    return 0;
                }
                return Math.floor(this.bucketWidth / this.viewWidth * graphDuration);
            },
            enumerable: true,
            configurable: true
        });
        CpuUsageViewModel.prototype.getCpuUsage = function () {
            var granularity = this.granularity;
            if(granularity <= 0) {
                return [];
            }
            var cpuData = this._model.getCpuUsage(this.activeRange, this.granularity);
            var chartData = cpuData.map(function (CpuUsage) {
                return {
                    x: CpuUsage.time,
                    height: CpuUsage.utilization,
                    series: CpuUsage.category,
                    attachedObject: CpuUsage
                };
            });
            return chartData;
        };
        CpuUsageViewModel.prototype.getSeries = function () {
            var seriesInfo = [];
            seriesInfo.push(this.createDataSeriesInfo("Loading_Category", "dataLoading", 1));
            seriesInfo.push(this.createDataSeriesInfo("Scripting_Category", "dataScripting", 2));
            seriesInfo.push(this.createDataSeriesInfo("GC_Category", "dataScriptingGc", 3));
            seriesInfo.push(this.createDataSeriesInfo("Styling_Category", "dataStyling", 4));
            seriesInfo.push(this.createDataSeriesInfo("Rendering_Category", "dataRendering", 5));
            seriesInfo.push(this.createDataSeriesInfo("ImageDecoding_Category", "dataImageDecoding", 6));
            seriesInfo.push(this.createDataSeriesInfo("Unknown_Category", "dataOther", 7));
            return seriesInfo;
        };
        CpuUsageViewModel.prototype.getVerticalRulerLinePositions = function () {
            return VisualProfiler.Graph.RulerUtilities.getVerticalLinePositions(this.activeRange, this.viewWidth);
        };
        CpuUsageViewModel.prototype.createDataSeriesInfo = function (categoryName, cssClass, sortOrder) {
            return new VisualProfiler.DataSeriesInfo(Plugin.Resources.getString(categoryName), categoryName, cssClass, sortOrder);
        };
        CpuUsageViewModel.prototype.onActiveRangeChanged = function (args) {
            if(this.activeRangeChanged) {
                this.activeRangeChanged();
            }
        };
        CpuUsageViewModel.prototype.onSelectionChanged = function (args) {
            var newSelection = args.data.newSelection;
            if(this._selection && this._selection.equals(newSelection)) {
                return;
            }
            if(this.selectionChanged) {
                this.selectionChanged(newSelection);
            }
        };
        return CpuUsageViewModel;
    })();
    VisualProfiler.CpuUsageViewModel = CpuUsageViewModel;    
    var CpuUsageView = (function (_super) {
        __extends(CpuUsageView, _super);
        function CpuUsageView(containerId) {
            var _this = this;
                _super.call(this, "cpuUsageView");
            this._minWidth = 200;
            this._resizeRenderDelay = 50;
            var parentContainer = document.getElementById(containerId);
            if(!containerId) {
                throw new Error(Plugin.Resources.getErrorString("JSPerf.1034"));
            }
            var resizeTimerId;
            window.addEventListener("resize", function () {
                clearTimeout(resizeTimerId);
                resizeTimerId = setTimeout(function () {
                    if(_this.viewModel) {
                        _this.render();
                    }
                }, _this._resizeRenderDelay);
            });
            parentContainer.appendChild(this.rootElement);
        }
        Object.defineProperty(CpuUsageView.prototype, "chartPresenter", {
            get: function () {
                return this._chartPresenter;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CpuUsageView.prototype, "minSelectionWidthInPixels", {
            set: function (value) {
                this._minSelectionWidthInPixels = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CpuUsageView.prototype, "viewModel", {
            get: function () {
                return this._viewModel;
            },
            set: function (model) {
                this.unregisterViewModelEvents();
                this.reset();
                this._viewModel = model;
                this.registerViewModelEvents();
            },
            enumerable: true,
            configurable: true
        });
        CpuUsageView.prototype.render = function () {
            this.setWidth();
            this.setupChart();
            this.showSelection();
        };
        CpuUsageView.prototype.setupChart = function () {
            var options = CpuUsageView.getChartOptions(this._viewModel, this.onChartSelectionChanged.bind(this), CpuUsageView.createToolTip, CpuUsageView.createAriaLabel, this._minSelectionWidthInPixels || 10);
            this._chartPresenter = new VisualProfiler.StackedBarChartPresenter(options);
            this.addSeries();
            this.addVerticalRulerLines();
            this.addCpuData();
            if(!this._chart) {
                this._chart = new VisualProfiler.StackedBarChartView();
                this.appendChild(this._chart);
            }
            this._chart.presenter = this._chartPresenter;
        };
        CpuUsageView.prototype.addCpuData = function () {
            var chartData = this._viewModel.getCpuUsage();
            this._chartPresenter.addData(chartData);
        };
        CpuUsageView.prototype.addSeries = function () {
            this._chartPresenter.addSeries(this._viewModel.getSeries());
        };
        CpuUsageView.prototype.addVerticalRulerLines = function () {
            this._chartPresenter.verticalRulerLinePositions = this._viewModel.getVerticalRulerLinePositions();
        };
        CpuUsageView.prototype.onActiveRangeChanged = function () {
            this.render();
        };
        CpuUsageView.prototype.onChartSelectionChanged = function (minValue, maxValue) {
            var begin = VisualProfiler.TimeStamp.fromNanoseconds(minValue);
            var end = VisualProfiler.TimeStamp.fromNanoseconds(maxValue);
            this._viewModel.selection = new VisualProfiler.TimeSpan(begin, end);
        };
        CpuUsageView.prototype.onRulerSelectionChanged = function (selection) {
            this._viewModel.selection = selection;
            this.showSelection();
        };
        CpuUsageView.prototype.registerViewModelEvents = function () {
            if(this._viewModel) {
                this._viewModel.activeRangeChanged = this.onActiveRangeChanged.bind(this);
                this._viewModel.selectionChanged = this.onRulerSelectionChanged.bind(this);
            }
        };
        CpuUsageView.prototype.reset = function () {
            if(this._chart) {
                this.removeChild(this._chart);
                this._chart = null;
            }
        };
        CpuUsageView.prototype.setWidth = function () {
            this._viewModel.viewWidth = Math.max(this.rootElement.offsetWidth, this._minWidth) - this._viewModel.yAxisWidth - this._viewModel.rightPadding;
        };
        CpuUsageView.prototype.showSelection = function () {
            this._chartPresenter.selection = this._viewModel.selection;
        };
        CpuUsageView.prototype.unregisterViewModelEvents = function () {
            if(this._viewModel) {
                this._viewModel.activeRangeChanged = null;
                this._viewModel.selectionChanged = null;
            }
        };
        CpuUsageView.getChartOptions = function getChartOptions(viewModel, selectionCallback, toolTipCallback, ariaLabelCallback, minSelectionWidthInPixels) {
            return {
                ariaDescription: Plugin.Resources.getString("CPUGraphAriaLabel"),
                height: 88,
                width: viewModel.viewWidth + viewModel.yAxisWidth + viewModel.rightPadding,
                title: Plugin.Resources.getString("CPUChartTitle"),
                minX: viewModel.activeRange.begin.nsec,
                maxX: viewModel.activeRange.end.nsec,
                minY: 0,
                minYHeight: 100,
                yAxisMarkValues: [
                    100, 
                    200
                ],
                barWidth: viewModel.barWidth,
                barGap: viewModel.barGap,
                showStackGap: true,
                minSelectionWidthInPixels: minSelectionWidthInPixels,
                selectionCallback: selectionCallback,
                toolTipCallback: toolTipCallback,
                ariaLabelCallback: ariaLabelCallback,
                displayLegend: true,
                yAxisWidth: viewModel.yAxisWidth,
                rightPadding: viewModel.rightPadding
            };
        }
        CpuUsageView.createToolTip = function createToolTip(CpuUsage) {
            var tip = "<div><span> " + Plugin.Resources.getString("CPUToolTipCategoryLabel") + ": </span><span>" + Plugin.Resources.getString(CpuUsage.category) + "</span></div>";
            tip += "<div><span> " + Plugin.Resources.getString("CPUToolTipUtilizationLabel") + ": </span><span>" + ((Math.round(CpuUsage.utilization * 100) / 100)).toLocaleString() + "%</span></div>";
            return tip;
        }
        CpuUsageView.createAriaLabel = function createAriaLabel(CpuUsage) {
            var percentageUtilization = ((Math.round(CpuUsage.utilization * 100) / 100)).toLocaleString();
            var formattedTime = VisualProfiler.FormattingHelpers.getPrettyPrintTime(VisualProfiler.TimeStamp.fromNanoseconds(CpuUsage.time));
            return Plugin.Resources.getString("CPUBarAriaLabel", Plugin.Resources.getString(CpuUsage.category), percentageUtilization, formattedTime);
        }
        return CpuUsageView;
    })(Common.Controls.TemplateControl);
    VisualProfiler.CpuUsageView = CpuUsageView;    
})(VisualProfiler || (VisualProfiler = {}));
//@ sourceMappingURL=CpuUsageView.js.map

// SIG // Begin signature block
// SIG // MIIalQYJKoZIhvcNAQcCoIIahjCCGoICAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFG4jfGERynfa
// SIG // Ao2FgjLWIjAyPfq1oIIVeTCCBLowggOioAMCAQICCmEC
// SIG // jkIAAAAAAB8wDQYJKoZIhvcNAQEFBQAwdzELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBMB4XDTEyMDEwOTIyMjU1OFoXDTEz
// SIG // MDQwOTIyMjU1OFowgbMxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // DTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIg
// SIG // RFNFIEVTTjpGNTI4LTM3NzctOEE3NjElMCMGA1UEAxMc
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgU2VydmljZTCCASIw
// SIG // DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJbsjkdN
// SIG // VMJclYDXTgs9v5dDw0vjYGcRLwFNDNjRRi8QQN4LpFBS
// SIG // EogLQ3otP+5IbmbHkeYDym7sealqI5vNYp7NaqQ/56ND
// SIG // /2JHobS6RPrfQMGFVH7ooKcsQyObUh8yNfT+mlafjWN3
// SIG // ezCeCjOFchvKSsjMJc3bXREux7CM8Y9DSEcFtXogC+Xz
// SIG // 78G69LPYzTiP+yGqPQpthRfQyueGA8Azg7UlxMxanMTD
// SIG // 2mIlTVMlFGGP+xvg7PdHxoBF5jVTIzZ3yrDdmCs5wHU1
// SIG // D92BTCE9djDFsrBlcylIJ9jC0rCER7t4utV0A97XSxn3
// SIG // U9542ob3YYgmM7RHxqBUiBUrLHUCAwEAAaOCAQkwggEF
// SIG // MB0GA1UdDgQWBBQv6EbIaNNuT7Ig0N6JTvFH7kjB8jAf
// SIG // BgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7syuwwzWzDzBU
// SIG // BgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vY3JsLm1pY3Jv
// SIG // c29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsGAQUFBwEBBEww
// SIG // SjBIBggrBgEFBQcwAoY8aHR0cDovL3d3dy5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRUaW1lU3Rh
// SIG // bXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsGAQUFBwMIMA0G
// SIG // CSqGSIb3DQEBBQUAA4IBAQBz/30unc2NiCt8feNeFXHp
// SIG // aGLwCLZDVsRcSi1o2PlIEZHzEZyF7BLUVKB1qTihWX91
// SIG // 7sb1NNhUpOLQzHyXq5N1MJcHHQRTLDZ/f/FAHgybgOIS
// SIG // CiA6McAHdWfg+jSc7Ij7VxzlWGIgkEUvXUWpyI6zfHJt
// SIG // ECfFS9hvoqgSs201I2f6LNslLbldsR4F50MoPpwFdnfx
// SIG // Jd4FRxlt3kmFodpKSwhGITWodTZMt7MIqt+3K9m+Kmr9
// SIG // 3zUXzD8Mx90Gz06UJGMgCy4krl9DRBJ6XN0326RFs5E6
// SIG // Eld940fGZtPPnEZW9EwHseAMqtX21Tyi4LXU+Bx+BFUQ
// SIG // axj0kc1Rp5VlMIIE7DCCA9SgAwIBAgITMwAAALARrwqL
// SIG // 0Duf3QABAAAAsDANBgkqhkiG9w0BAQUFADB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQTAeFw0xMzAxMjQyMjMzMzla
// SIG // Fw0xNDA0MjQyMjMzMzlaMIGDMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYDVQQDExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24wggEiMA0GCSqGSIb3DQEB
// SIG // AQUAA4IBDwAwggEKAoIBAQDor1yiIA34KHy8BXt/re7r
// SIG // dqwoUz8620B9s44z5lc/pVEVNFSlz7SLqT+oN+EtUO01
// SIG // Fk7vTXrbE3aIsCzwWVyp6+HXKXXkG4Unm/P4LZ5BNisL
// SIG // QPu+O7q5XHWTFlJLyjPFN7Dz636o9UEVXAhlHSE38Cy6
// SIG // IgsQsRCddyKFhHxPuRuQsPWj/ov0DJpOoPXJCiHiquMB
// SIG // Nkf9L4JqgQP1qTXclFed+0vUDoLbOI8S/uPWenSIZOFi
// SIG // xCUuKq6dGB8OHrbCryS0DlC83hyTXEmmebW22875cHso
// SIG // AYS4KinPv6kFBeHgD3FN/a1cI4Mp68fFSsjoJ4TTfsZD
// SIG // C5UABbFPZXHFAgMBAAGjggFgMIIBXDATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzAdBgNVHQ4EFgQUWXGmWjNN2pgHgP+E
// SIG // Hr6H+XIyQfIwUQYDVR0RBEowSKRGMEQxDTALBgNVBAsT
// SIG // BE1PUFIxMzAxBgNVBAUTKjMxNTk1KzRmYWYwYjcxLWFk
// SIG // MzctNGFhMy1hNjcxLTc2YmMwNTIzNDRhZDAfBgNVHSME
// SIG // GDAWgBTLEejK0rQWWAHJNy4zFha5TJoKHzBWBgNVHR8E
// SIG // TzBNMEugSaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NybC9wcm9kdWN0cy9NaWNDb2RTaWdQQ0Ff
// SIG // MDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUHAQEETjBMMEoG
// SIG // CCsGAQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NlcnRzL01pY0NvZFNpZ1BDQV8wOC0zMS0y
// SIG // MDEwLmNydDANBgkqhkiG9w0BAQUFAAOCAQEAMdduKhJX
// SIG // M4HVncbr+TrURE0Inu5e32pbt3nPApy8dmiekKGcC8N/
// SIG // oozxTbqVOfsN4OGb9F0kDxuNiBU6fNutzrPJbLo5LEV9
// SIG // JBFUJjANDf9H6gMH5eRmXSx7nR2pEPocsHTyT2lrnqkk
// SIG // hNrtlqDfc6TvahqsS2Ke8XzAFH9IzU2yRPnwPJNtQtjo
// SIG // fOYXoJtoaAko+QKX7xEDumdSrcHps3Om0mPNSuI+5PNO
// SIG // /f+h4LsCEztdIN5VP6OukEAxOHUoXgSpRm3m9Xp5QL0f
// SIG // zehF1a7iXT71dcfmZmNgzNWahIeNJDD37zTQYx2xQmdK
// SIG // Dku/Og7vtpU6pzjkJZIIpohmgjCCBbwwggOkoAMCAQIC
// SIG // CmEzJhoAAAAAADEwDQYJKoZIhvcNAQEFBQAwXzETMBEG
// SIG // CgmSJomT8ixkARkWA2NvbTEZMBcGCgmSJomT8ixkARkW
// SIG // CW1pY3Jvc29mdDEtMCsGA1UEAxMkTWljcm9zb2Z0IFJv
// SIG // b3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5MB4XDTEwMDgz
// SIG // MTIyMTkzMloXDTIwMDgzMTIyMjkzMloweTELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWljcm9zb2Z0IENv
// SIG // ZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqGSIb3DQEBAQUA
// SIG // A4IBDwAwggEKAoIBAQCycllcGTBkvx2aYCAgQpl2U2w+
// SIG // G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/3sJCTiPVcgDb
// SIG // NVcKicquIEn08GisTUuNpb15S3GbRwfa/SXfnXWIz6pz
// SIG // RH/XgdvzvfI2pMlcRdyvrT3gKGiXGqelcnNW8ReU5P01
// SIG // lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJpL9oZC/6SdCni
// SIG // di9U3RQwWfjSjWL9y8lfRjFQuScT5EAwz3IpECgixzdO
// SIG // PaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn0i1i8UU956wI
// SIG // APZGoZ7RW4wmU+h6qkryRs83PDietHdcpReejcsRj1Y8
// SIG // wawJXwPTAgMBAAGjggFeMIIBWjAPBgNVHRMBAf8EBTAD
// SIG // AQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGCNxUBBAUCAwEA
// SIG // ATAjBgkrBgEEAYI3FQIEFgQU/dExTtMmipXhmGA7qDFv
// SIG // pjy82C0wGQYJKwYBBAGCNxQCBAweCgBTAHUAYgBDAEEw
// SIG // HwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8KuEKU5VZ5KQw
// SIG // UAYDVR0fBEkwRzBFoEOgQYY/aHR0cDovL2NybC5taWNy
// SIG // b3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvbWljcm9z
// SIG // b2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUFBwEBBEgwRjBE
// SIG // BggrBgEFBQcwAoY4aHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNyb3NvZnRSb290Q2VydC5j
// SIG // cnQwDQYJKoZIhvcNAQEFBQADggIBAFk5Pn8mRq/rb0Cx
// SIG // MrVq6w4vbqhJ9+tfde1MOy3XQ60L/svpLTGjI8x8UJiA
// SIG // IV2sPS9MuqKoVpzjcLu4tPh5tUly9z7qQX/K4QwXacul
// SIG // nCAt+gtQxFbNLeNK0rxw56gNogOlVuC4iktX8pVCnPHz
// SIG // 7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y4k74jKHK6BOl
// SIG // kU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wdzaKMvSeyeWNW
// SIG // RKJRzfnpo1hW3ZsCRUQvX/TartSCMm78pJUT5Otp56mi
// SIG // LL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q70eFW6NB4lhhc
// SIG // yTUWX92THUmOLb6tNEQc7hAVGgBd3TVbIc6YxwnuhQ6M
// SIG // T20OE049fClInHLR82zKwexwo1eSV32UjaAbSANa98+j
// SIG // Zwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKNMxZlHg6K3RDe
// SIG // ZPRvzkbU0xfpecQEtNP7LN8fip6sCvsTJ0Ct5PnhqX9G
// SIG // uwdgR2VgQE6wQuxO7bN2edgKNAltHIAxH+IOVN3lofvl
// SIG // RxCtZJj/UBYufL8FIXrilUEnacOTj5XJjdibIa4NXJzw
// SIG // oq6GaIMMai27dmsAHZat8hZ79haDJLmIz2qoRzEvmtzj
// SIG // cT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq/2mbluIQqBC0
// SIG // N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZoNAAAAAAAHDAN
// SIG // BgkqhkiG9w0BAQUFADBfMRMwEQYKCZImiZPyLGQBGRYD
// SIG // Y29tMRkwFwYKCZImiZPyLGQBGRYJbWljcm9zb2Z0MS0w
// SIG // KwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBDZXJ0aWZpY2F0
// SIG // ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1MzA5WhcNMjEw
// SIG // NDAzMTMwMzA5WjB3MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSEw
// SIG // HwYDVQQDExhNaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Ew
// SIG // ggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCf
// SIG // oWyx39tIkip8ay4Z4b3i48WZUSNQrc7dGE4kD+7Rp9FM
// SIG // rXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr6Hu97IkHD/cO
// SIG // BJjwicwfyzMkh53y9GccLPx754gd6udOo6HBI1PKjfpF
// SIG // zwnQXq/QsEIEovmmbJNn1yjcRlOwhtDlKEYuJ6yGT1VS
// SIG // DOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd++NIT8wi3U21S
// SIG // tEWQn0gASkdmEScpZqiX5NMGgUqi+YSnEUcUCYKfhO1V
// SIG // eP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68eeEExd8yb3zuD
// SIG // k6FhArUdDbH895uyAc4iS1T/+QXDwiALAgMBAAGjggGr
// SIG // MIIBpzAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBQj
// SIG // NPjZUkZwCu1A+3b7syuwwzWzDzALBgNVHQ8EBAMCAYYw
// SIG // EAYJKwYBBAGCNxUBBAMCAQAwgZgGA1UdIwSBkDCBjYAU
// SIG // DqyCYEBWJ5flJRP8KuEKU5VZ5KShY6RhMF8xEzARBgoJ
// SIG // kiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJk/IsZAEZFglt
// SIG // aWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jvc29mdCBSb290
// SIG // IENlcnRpZmljYXRlIEF1dGhvcml0eYIQea0WoUqgpa1M
// SIG // c1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BBhj9odHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9taWNyb3NvZnRyb290Y2VydC5jcmwwVAYIKwYBBQUH
// SIG // AQEESDBGMEQGCCsGAQUFBzAChjhodHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY3Jvc29mdFJv
// SIG // b3RDZXJ0LmNydDATBgNVHSUEDDAKBggrBgEFBQcDCDAN
// SIG // BgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wDRDbd6bStd9vO
// SIG // eVFNAbEudHFbbQwTq86+e4+4LtQSooxtYrhXAstOIBNQ
// SIG // md16QOJXu69YmhzhHQGGrLt48ovQ7DsB7uK+jwoFyI1I
// SIG // 4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mRKiQicPv2/OR4
// SIG // mS4N9wficLwYTp2OawpylbihOZxnLcVRDupiXD8WmIsg
// SIG // P+IHGjL5zDFKdjE9K3ILyOpwPf+FChPfwgphjvDXuBfr
// SIG // Tot/xTUrXqO/67x9C0J71FNyIe4wyrt4ZVxbARcKFA7S
// SIG // 2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGysOUzU9nm/qhh6
// SIG // YinvopspNAZ3GmLJPR5tH4LwC8csu89Ds+X57H2146So
// SIG // dDW4TsVxIxImdgs8UoxxWkZDFLyzs7BNZ8ifQv+AeSGA
// SIG // nhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU2DKATCYqSCRf
// SIG // WupW76bemZ3KOm+9gSd0BhHudiG/m4LBJ1S2sWo9iaF2
// SIG // YbRuoROmv6pH8BJv/YoybLL+31HIjCPJZr2dHYcSZAI9
// SIG // La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCleKuzoJZ1GtmS
// SIG // hxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/Jmu5J4PcBZW+J
// SIG // C33Iacjmbuqnl84xKf8OxVtc2E0bodj6L54/LlUWa8kT
// SIG // o/0xggSIMIIEhAIBATCBkDB5MQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQgQ29kZSBTaWdu
// SIG // aW5nIFBDQQITMwAAALARrwqL0Duf3QABAAAAsDAJBgUr
// SIG // DgMCGgUAoIGqMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3
// SIG // AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEV
// SIG // MCMGCSqGSIb3DQEJBDEWBBRTkqNvARSIw5uKkQXXLTpp
// SIG // AxPYRDBKBgorBgEEAYI3AgEMMTwwOqAggB4AQwBwAHUA
// SIG // VQBzAGEAZwBlAFYAaQBlAHcALgBqAHOhFoAUaHR0cDov
// SIG // L21pY3Jvc29mdC5jb20wDQYJKoZIhvcNAQEBBQAEggEA
// SIG // qFHhPCf2T/jhtf+aTRuqyChbrDIpl1UbckRRSErYVkSK
// SIG // loxW+UKMEIw/ZlmCs+XhGDMoa49eAJd7dU+A8zHjL2to
// SIG // crbWljWDrtWjJRDR2me1Jhkd0frm8n1FLr9A/JvHaZ12
// SIG // /mK+m2gUU9Cu56aweTdAjD7/yaZNaXAAc7kXM5nLVcuM
// SIG // kpNAuVeqx77BhCoWH1eSEMdmyJTbIsEeVEsG9XJ6Rvdu
// SIG // xAP25gArMnQXSZQJD+i4E8iXz7K7zrWTqFvt/7u9C5Js
// SIG // drJ0s80CJ+Na4a29U5rIDqC+PRdiBGu80alfoyRJUyBy
// SIG // s5hoaxDnrjXA+VBoiX7SRpYejJ3woh9pvaGCAh8wggIb
// SIG // BgkqhkiG9w0BCQYxggIMMIICCAIBATCBhTB3MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQg
// SIG // VGltZS1TdGFtcCBQQ0ECCmECjkIAAAAAAB8wCQYFKw4D
// SIG // AhoFAKBdMBgGCSqGSIb3DQEJAzELBgkqhkiG9w0BBwEw
// SIG // HAYJKoZIhvcNAQkFMQ8XDTEzMDMxNTA2MzQwMlowIwYJ
// SIG // KoZIhvcNAQkEMRYEFMFBh1wxnfS+7SiBN6S/BPu3KmPS
// SIG // MA0GCSqGSIb3DQEBBQUABIIBAHxG0doFhY0Z2E6pY6CB
// SIG // UcC81vkeHFHbD8dJHbFZwg1K54PoDUWRDqvHryG++F6+
// SIG // q4RVMFiPtiRGuGp8cqZI2KmfDGfrK2U2HGSaof9mA5o7
// SIG // NN1BE6zntID+N1+Q1bXyIuEd2G2GzZT5kBTsOSCPnC22
// SIG // hmdh2Lh9iGm/wJTfkWjqouf5mt4Qalk3zKfW7+Xandex
// SIG // HSEVQHEK9a3RFbKD//p+hKYryrb6f3tMXUfPSIIDiC7M
// SIG // oLjwY/OWOY5BNMthj5gFiXRQINJiM1CbrqL2p8YiqkVn
// SIG // 3jQRQEA4ex22HIqbheysl6BBPSbugqZzhNGeDFbF/sV2
// SIG // 4+uXF9t+l7FBY2s=
// SIG // End signature block
